<?php
	/*Database Connection*/
	include("dbconnection.php");
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>MySQL Data to Excel Export</title>
    <!-- favicon-->
	<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
	<link rel="icon" href="images/favicon.ico" type="image/x-icon">
    <!-- Bootstrap css-->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">    
	<!-- style -->
    <link href="style.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.min.js"></script>
      <script src="assets/js/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="header">
					<div><img src="images/logo.png" /></div>
					<h2 style="text-align: center;">REPORTES DE INCIDENCIAS & MANTENIMIENTOS</h2>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-3">
				<div class="panel-area">
					<div class="panel-header">
						<div class="header-title">Tables Export</div>
					</div>
					<div class="panel-content">
						<ul class="nav nav-list">
							<li><a href="index.php">Basic</a></li>
							<li class="active"><a href="row-grouping.php">Row Grouping</a></li>
							<li><a href="header-rows-columns-merge.php">Header (Rows and Columns Merge)</a></li>
							<li><a href="autofilter-range-of-cells.php">Autofilter Range of Cells</a></li>
							<li><a href="formula-calculations.php">Formula Calculations</a></li>
							<li><a href="protected-and-unprotected-on-cells.php">Protected and Unprotected on Cells</a></li>
						</ul>
					</div>
					<div class="panel-header">
						<div class="header-title">Images Export</div>
					</div>
					<div class="panel-content">
						<ul class="nav nav-list">
							<li><a href="image-with-description.php">Image With Description</a></li>
						</ul>
					</div>
				</div>
			</div>
		
			<div class="col-md-9">
				<div class="panel-area">
					<div class="panel-header">
						<div class="inner-panel">
							<h5 class="rules-title">Reporte de Ordenes No Completadas</h5>
							<a href="row-grouping-excel.php" class="btn btn-primary pull-right">
								<span class="glyphicon glyphicon-export" aria-hidden="true"></span> Excel Export
							</a>
						</div>
					</div>
					<div class="panel-content">
						<div class="table-responsive">
							<table class="table table-bordered table-hover" cellspacing="0" width="100%">
								<thead>
									<tr>
										<th class="text-center" style="width:15%;">Titulo</th> 
										<th class="text-center" style="width:15%;">Tipo de Orden</th> 
										<th class="text-center" style="width:15%;">Fecha</th> 
										<th class="text-center" style="width:40%;">Descripcion</th>
										<th class="text-center" style="width:15%;">Estatus</th> 
									</tr>
								</thead>
								<tbody>
									<?php
									/*sql*/
									$sql = "SELECT Titulo, Tipodeorden, Fecha, Descripcion, Status,Mes FROM ordendetrabajo;";
									$result = mysqli_query($con, $sql);
									$i=1;
									$tempDate = '';
									while ($aRow = mysqli_fetch_array($result)) {
										if($tempDate!=$aRow['Mes']) {
									?>
									<tr> 
										<td style="background-color:#f3faf6;" colspan="7"><?php echo $aRow['Mes']; ?></td> 
									</tr> 
									<?php 
										$tempDate=$aRow['Mes'];
										}
									?>
									<tr>  
										<td class="text-center"><?php echo $aRow['Titulo']; ?></td> 
										<td class="text-center"><?php echo $aRow['Tipodeorden']; ?></td>  
										<td class="text-center"><?php echo $aRow['Fecha']; ?></td> 
										<td><?php echo $aRow['Descripcion']; ?></td>
										<td class="text-center"><?php echo $aRow['Status']; ?></td>
										  
									</tr> 
									<?php }	?>
									
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
    <!-- jQuery plugins -->
    <script src="assets/js/jquery-3.2.1.min.js"></script>
    <!-- bootstrap js -->
    <script src="assets/js/bootstrap.min.js"></script>

  </body>
</html>