<?php
/**
 * pagos_adelantados_apply_V6.php
 *
 * FIX PRINCIPAL:
 * - NO insertar línea contable en el MES ACTUAL cuando el mes destino = MES ACTUAL,
 *   para evitar que se duplique (Septiembre aparece 2 veces en el UI).
 *
 * Notas:
 * - mantenimientopagodetalle usa ItemID como PK (no ID).
 * - UNION REAL: mantenimientopago.ID <-> mantenimientopagodetalle.InvID
 *
 * POST:
 *  condominio, residencia, base_id, mes, ano, prioridad(atrasados|futuros), total
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', '0');

include 'dbconnection.php';

function jexit($ok, $arr = array()){
  echo json_encode(array_merge(array('ok'=>$ok), $arr), JSON_UNESCAPED_UNICODE);
  exit;
}
function esc($con, $v){ return mysqli_real_escape_string($con, (string)$v); }

function dec($v){
  $s = str_replace(' ', '', (string)$v);
  if (strpos($s, ',') !== false && strpos($s, '.') === false) $s = str_replace(',', '.', $s);
  else $s = str_replace(',', '', $s);
  return (float)$s;
}

function mesNum($mes){
  $m = strtolower(trim((string)$mes));
  $map = array(
    'enero'=>1,'febrero'=>2,'marzo'=>3,'abril'=>4,'mayo'=>5,'junio'=>6,
    'julio'=>7,'agosto'=>8,'septiembre'=>9,'setiembre'=>9,'octubre'=>10,'noviembre'=>11,'diciembre'=>12
  );
  return isset($map[$m]) ? $map[$m] : 0;
}
function keyYM($ano,$mes){
  $mm = mesNum($mes);
  $yy = (int)$ano;
  if ($mm<=0 || $yy<=0) return 0;
  return ($yy*100)+$mm;
}
function mesesES(){
  return array('Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
}
function nextMesAno($mes, $ano){
  $meses = mesesES();
  $n = mesNum($mes);
  $y = (int)$ano;
  if ($n <= 0) return array($mes, $ano);
  $n++;
  if ($n > 12) { $n = 1; $y++; }
  return array($meses[$n-1], (string)$y);
}

// Replica tu lógica de estatus (similar al trigger)
function calcStatus($restante, $adjuntarimagen, $parcial){
  if ($restante <= 2 && $restante >= -2) return 'Pagado';
  if ((string)$adjuntarimagen !== 'NULL' && (string)$parcial === '0') return 'Revision';
  return 'No Pagado';
}

// Trigger (igual que tu código original)
function dropTriggerCuotaestatus($con){
  @mysqli_query($con, "DROP TRIGGER IF EXISTS Cuotaestatus");
}
function createTriggerCuotaestatus($con){
  $sql = "CREATE TRIGGER `Cuotaestatus` BEFORE UPDATE ON `mantenimientopago`
  FOR EACH ROW BEGIN
    IF (NEW.Pagorestante <= 2 AND NEW.Pagorestante >= -2) THEN SET New.Pagostatus = 'Pagado';
    ELSEIF (NEW.Adjuntarimagen !='NULL'AND NEW.Pagoparcial='0') THEN SET New.Pagostatus = 'Revision';
    ELSE SET New.Pagostatus = 'No Pagado';
    END IF;
    IF (NEW.Pagostatus != OLD.Pagostatus) THEN SET NEW.Enviar = '1';
    END IF;
  END";
  @mysqli_query($con, $sql);
}

// Asegura que exista al menos 1 detalle para un InvID (usa ItemID)
function ensureDetalleExists($con, $invID, $mes, $ano, $condominio, $residencia, $nombres, $apellidos, $cuota){
  $inv = esc($con, (string)$invID);
  $rs = mysqli_query($con, "SELECT ItemID FROM mantenimientopagodetalle WHERE InvID='$inv' LIMIT 1");
  if ($rs && mysqli_num_rows($rs) > 0) return true;

  // Crear fila base (Cuota Basica) con Totalpagado=0
  $Concepto = 'Cuota Basica';
  $sql = "INSERT IGNORE INTO mantenimientopagodetalle
    (InvID,Amount,Qty,Items,Mes,Ano,Condominio,Residencia,Totalpagado,Nombres,Apellidos)
    VALUES
    ('$inv', ".dec($cuota).", '1', '".esc($con,$Concepto)."', '".esc($con,$mes)."', '".esc($con,$ano)."', '".esc($con,$condominio)."', '".esc($con,$residencia)."', 0, '".esc($con,$nombres)."', '".esc($con,$apellidos)."')";
  $ok = mysqli_query($con, $sql);
  if (!$ok) return mysqli_error($con);

  $rs2 = mysqli_query($con, "SELECT ItemID FROM mantenimientopagodetalle WHERE InvID='$inv' LIMIT 1");
  if ($rs2 && mysqli_num_rows($rs2) > 0) return true;

  return "No se pudo crear/encontrar detalle para InvID=$invID";
}

// Sumar Totalpagado en el detalle del mes destino (para que el UI muestre Total Pagado)
function aplicarEnDetalleDestino($con, $invID, $monto){
  $inv = esc($con, (string)$invID);
  $m = dec($monto);

  // Preferido: Items='Cuota Basica'
  $rs = mysqli_query($con, "SELECT ItemID FROM mantenimientopagodetalle WHERE InvID='$inv' AND Items='Cuota Basica' ORDER BY ItemID ASC LIMIT 1");
  if ($rs && ($r=mysqli_fetch_assoc($rs))){
    $itemID = (int)$r['ItemID'];
    $sql = "UPDATE mantenimientopagodetalle SET Totalpagado = IFNULL(Totalpagado,0) + $m WHERE ItemID=$itemID LIMIT 1";
    return mysqli_query($con, $sql) ? true : mysqli_error($con);
  }

  // Fallback: primera fila
  $rs2 = mysqli_query($con, "SELECT ItemID FROM mantenimientopagodetalle WHERE InvID='$inv' ORDER BY ItemID ASC LIMIT 1");
  if ($rs2 && ($r2=mysqli_fetch_assoc($rs2))){
    $itemID = (int)$r2['ItemID'];
    $sql = "UPDATE mantenimientopagodetalle SET Totalpagado = IFNULL(Totalpagado,0) + $m WHERE ItemID=$itemID LIMIT 1";
    return mysqli_query($con, $sql) ? true : mysqli_error($con);
  }

  return "No existe detalle destino para InvID=$invID";
}

// Insertar línea contable en el MES ACTUAL (InvID = base_id)
// IMPORTANTE: esto se usa SOLO para meses adelantados (no para el mismo mes actual)
function insertarLineaMesActual($con, $base_id, $cuotaBase, $concepto, $mesDestino, $anoDestino, $condominio, $residencia, $montoAplicado, $nombres, $apellidos, $mesActual, $anoActual){
  $sql = "INSERT IGNORE INTO mantenimientopagodetalle
    (InvID,Amount,Qty,Items,Mes,Ano,Condominio,Residencia,Totalpagado,Tipodepago,Nombres,Apellidos,Mesactual,Anoactual)
    VALUES
    ('".esc($con,$base_id)."', ".dec($cuotaBase).", '1', '".esc($con,$concepto)."', '".esc($con,$mesDestino)."', '".esc($con,$anoDestino)."', '".esc($con,$condominio)."', '".esc($con,$residencia)."', ".dec($montoAplicado).", 'Adelantado', '".esc($con,$nombres)."', '".esc($con,$apellidos)."', '".esc($con,$mesActual)."', '".esc($con,$anoActual)."')";
  $ok = mysqli_query($con, $sql);
  return $ok ? true : mysqli_error($con);
}

// Asegura que el mes destino exista en mantenimientopago y devuelve su ID
function ensureMesExiste($con, $condominio, $residencia, $mes, $ano){
  $escCon = esc($con, $condominio);
  $escRes = esc($con, $residencia);
  $escMes = esc($con, $mes);
  $escAno = esc($con, $ano);

  $rs = mysqli_query($con, "SELECT ID FROM mantenimientopago WHERE Condominio='$escCon' AND Residencia='$escRes' AND Mes='$escMes' AND Ano='$escAno' LIMIT 1");
  if ($rs && ($r = mysqli_fetch_assoc($rs))) return (int)$r['ID'];

  // Envioauto
  $Envioauto = '';
  $q1 = mysqli_query($con, "SELECT Envioauto FROM condominios WHERE Nombre='$escCon' LIMIT 1");
  if ($q1 && ($r1=mysqli_fetch_assoc($q1))) $Envioauto = $r1['Envioauto'];

  // Residentes
  $Nombres = $Apellidos = $Email = '';
  $Cuota = 0.0;
  $Cuentaprincipal = $Cuentasecundaria = '';
  $q2 = mysqli_query($con, "SELECT * FROM residentes WHERE Condominio='$escCon' AND Residencia='$escRes' LIMIT 1");
  if ($q2 && ($r2=mysqli_fetch_assoc($q2))){
    $Nombres = $r2['Nombres'];
    $Apellidos = $r2['Apellidos'];
    $Email = $r2['Email'];
    $Cuota = dec($r2['Cuota']);
    $Cuentaprincipal = $r2['Cuentaprincipal'];
    $Cuentasecundaria = $r2['Cuentasecundaria'];
  }

  $ins = mysqli_query($con, "
    INSERT IGNORE INTO mantenimientopago
      (Condominio,Residencia,Mes,Ano,Condominio2,Tipocuota,Envioauto,Nombres,Apellidos,email,Cuota,Cuentaprincipal,Cuentasecundaria,Pagostatus,Pagoparcial)
    VALUES
      ('$escCon','$escRes','$escMes','$escAno','$escCon','Normal','".esc($con,$Envioauto)."','".esc($con,$Nombres)."','".esc($con,$Apellidos)."','".esc($con,$Email)."',$Cuota,'".esc($con,$Cuentaprincipal)."','".esc($con,$Cuentasecundaria)."','No Pagado','0')
  ");
  if (!$ins) return 0;

  $rs2 = mysqli_query($con, "SELECT ID, Cuota, Nombres, Apellidos FROM mantenimientopago WHERE Condominio='$escCon' AND Residencia='$escRes' AND Mes='$escMes' AND Ano='$escAno' LIMIT 1");
  if (!$rs2 || !($r3=mysqli_fetch_assoc($rs2))) return 0;
  $ID2 = (int)$r3['ID'];

  
  // ---- FIX: entry_by + fechadeentrada (solo cuando se CREA el mes) ----
  // entry_by: tomar tb_users.id por email (para que el usuario vea el documento)
  @mysqli_query($con, "UPDATE mantenimientopago mp JOIN tb_users u ON u.email = mp.email
                       SET mp.entry_by = u.id
                       WHERE mp.ID=$ID2 AND (mp.entry_by IS NULL OR mp.entry_by=0)");

  // fechadeentrada: YYYY-MM-01 segun Mes/Ano
  $mm = mesNum($mes);
  if ($mm > 0) {
    $fechaentrada = sprintf('%04d-%02d-01', (int)$ano, (int)$mm);
    @mysqli_query($con, "UPDATE mantenimientopago SET fechadeentrada='$fechaentrada'
                         WHERE ID=$ID2 AND (fechadeentrada IS NULL OR fechadeentrada='' OR fechadeentrada='0000-00-00')");
  }

  // Asegurar detalle base
  $detOk = ensureDetalleExists($con, $ID2, $mes, $ano, $condominio, $residencia, $r3['Nombres'], $r3['Apellidos'], $r3['Cuota']);
  if ($detOk !== true) return 0;

  // Totales
  $inv = esc($con, (string)$ID2);
  @mysqli_query($con, "UPDATE mantenimientopago SET InvTotal=(SELECT SUM(Amount*Qty) FROM mantenimientopagodetalle WHERE InvID='$inv') WHERE ID=$ID2");
  @mysqli_query($con, "UPDATE mantenimientopago SET Pagorealizado=(SELECT SUM(Totalpagado) FROM mantenimientopagodetalle WHERE InvID='$inv') WHERE ID=$ID2");
  @mysqli_query($con, "UPDATE mantenimientopago SET Pagorestante = IFNULL(InvTotal,0) - IFNULL(Pagorealizado,0) WHERE ID=$ID2");

  return $ID2;
}

/* ===== Inputs ===== */
$Condominio = isset($_POST['condominio']) ? $_POST['condominio'] : '';
$Residencia = isset($_POST['residencia']) ? $_POST['residencia'] : '';
$base_id    = isset($_POST['base_id']) ? $_POST['base_id'] : '';
$MesInicio  = isset($_POST['mes']) ? $_POST['mes'] : '';
$AnoInicio  = isset($_POST['ano']) ? $_POST['ano'] : '';
$prioridad  = isset($_POST['prioridad']) ? $_POST['prioridad'] : 'atrasados';
$monto      = dec(isset($_POST['total']) ? $_POST['total'] : 0);

if (!$Condominio || !$Residencia || !$base_id) jexit(false, array('error'=>'Faltan datos (condominio/residencia/base_id).','post'=>$_POST));
if ($monto <= 0) jexit(false, array('error'=>'Monto inválido.'));
$startKey = keyYM($AnoInicio, $MesInicio);
if ($startKey <= 0) jexit(false, array('error'=>'Mes/Año inválidos.'));

$baseInt = (int)$base_id;
$rsBase = mysqli_query($con, "SELECT * FROM mantenimientopago WHERE ID=$baseInt LIMIT 1");
if (!$rsBase) jexit(false, array('error'=>'DB base: '.mysqli_error($con)));
$baseRow = mysqli_fetch_assoc($rsBase);
if (!$baseRow) jexit(false, array('error'=>"No existe mantenimientopago.ID=$baseInt"));

// Datos base (MES ACTUAL REAL)
$Mesactual = $baseRow['Mes'];
$Anoactual = $baseRow['Ano'];
$Nombres4  = $baseRow['Nombres'];
$Apellidos4= $baseRow['Apellidos'];
$Cuota3    = $baseRow['Cuota'];
$fechaPago = date('Y-m-d');

// Asegurar detalle del mes actual (para poder pagar mes actual también)
$detBaseOk = ensureDetalleExists($con, $baseInt, $Mesactual, $Anoactual, $Condominio, $Residencia, $Nombres4, $Apellidos4, $Cuota3);
if ($detBaseOk !== true) jexit(false, array('error'=>'Mes actual falló: '.$detBaseOk));

// Evitar conflictos con trigger durante updates masivos
dropTriggerCuotaestatus($con);

$escCon = esc($con, $Condominio);
$escRes = esc($con, $Residencia);

// Cargar pendientes (incluye mes actual si está No Pagado o con restante)
$rs = mysqli_query($con, "
  SELECT ID, Mes, Ano, InvTotal, Pagorealizado, Pagorestante, Pagostatus, Adjuntarimagen, Pagoparcial
  FROM mantenimientopago
  WHERE Condominio='$escCon'
    AND Residencia='$escRes'
    AND (Pagostatus IS NULL OR Pagostatus <> 'Pagado')
");
if (!$rs) { createTriggerCuotaestatus($con); jexit(false, array('error'=>'DB pendientes: '.mysqli_error($con))); }

$atras = array(); $fut = array();
while ($r = mysqli_fetch_assoc($rs)) {
  $k = keyYM($r['Ano'], $r['Mes']);
  if ($k <= 0) continue;

  $rest = dec($r['Pagorestante']);
  if ($rest <= 0) $rest = dec($r['InvTotal']) - dec($r['Pagorealizado']);
  if ($rest <= 0) continue;

  $r['_key'] = $k;
  $r['_rest'] = $rest;

  if ($k < $startKey) $atras[] = $r;
  else $fut[] = $r; // incluye mes inicio (puede ser Septiembre 2025)
}

usort($atras, function($a,$b){ return $a['_key'] <=> $b['_key']; });
usort($fut,   function($a,$b){ return $a['_key'] <=> $b['_key']; });

$cola = ($prioridad === 'futuros') ? array_merge($fut, $atras) : array_merge($atras, $fut);

$saldo = round($monto, 2);
$aplicado = 0.0;
$aplicaciones = array();

// Aplicar a existentes
foreach ($cola as $c) {
  if ($saldo <= 0) break;

  $ap = ($saldo < $c['_rest']) ? $saldo : $c['_rest'];
  $ap = round($ap, 2);

  $nuevoPagado = round(dec($c['Pagorealizado']) + $ap, 2);
  $nuevoRest   = round($c['_rest'] - $ap, 2);

  $parcial = ($nuevoRest > 0) ? '1' : '0';
  $estado  = calcStatus($nuevoRest, $c['Adjuntarimagen'], $parcial);

  $id = (int)$c['ID'];

  // Asegurar detalle destino antes de actualizar
  $detOk = ensureDetalleExists($con, $id, $c['Mes'], $c['Ano'], $Condominio, $Residencia, $Nombres4, $Apellidos4, $Cuota3);
  if ($detOk !== true) { createTriggerCuotaestatus($con); jexit(false, array('error'=>'Detalle destino (InvID='.$id.') no existe y no se pudo crear: '.$detOk)); }

  $up = mysqli_query($con, "
    UPDATE mantenimientopago
    SET Pagorealizado = $nuevoPagado,
        Pagorestante  = $nuevoRest,
        Pagoparcial   = '$parcial',
        Pagostatus    = '$estado',
        Fechapago     = '$fechaPago'
    WHERE ID=$id
    LIMIT 1
  ");
  if (!$up) { createTriggerCuotaestatus($con); jexit(false, array('error'=>"DB update ID $id: ".mysqli_error($con))); }

  // Reflejar Totalpagado en detalle destino (ItemID)
  $okDet = aplicarEnDetalleDestino($con, $id, $ap);
  if ($okDet !== true) { createTriggerCuotaestatus($con); jexit(false, array('error'=>"Detalle destino (InvID=$id) no actualizado: $okDet")); }

  // ✅ FIX: NO insertar línea contable si el mes destino ES el mismo mes actual
  $esMesActual = ((string)$c['Mes'] === (string)$Mesactual && (string)$c['Ano'] === (string)$Anoactual);

  if (!$esMesActual) {
    // aquí sí es adelantado => va como línea en el mes actual
    $Concepto = 'Cuota Basica'; // si quieres diferenciar: 'Pago Adelantado'
    $insLine = insertarLineaMesActual($con, $base_id, $Cuota3, $Concepto, $c['Mes'], $c['Ano'], $Condominio, $Residencia, $ap, $Nombres4, $Apellidos4, $Mesactual, $Anoactual);
    if ($insLine !== true) { createTriggerCuotaestatus($con); jexit(false, array('error'=>"No pudo insertar línea en mes actual: $insLine")); }
  }

  $saldo = round($saldo - $ap, 2);
  $aplicado = round($aplicado + $ap, 2);

  $aplicaciones[] = array('ID'=>(string)$id,'Mes'=>$c['Mes'],'Ano'=>$c['Ano'],'Aplicado'=>$ap,'Restante'=>($nuevoRest<0?0:$nuevoRest),'Estado'=>$estado,'linea_mes_actual'=>($esMesActual?0:1));
}

// Si sobra saldo, generar meses futuros y aplicar (arranca en el SIGUIENTE mes de MesInicio)
if ($saldo > 0) {
  $mesCur = $MesInicio;
  $anoCur = $AnoInicio;

  $guard = 0;
  while ($saldo > 0 && $guard < 36) {
    $guard++;
    list($mesCur, $anoCur) = nextMesAno($mesCur, $anoCur); // => Octubre si MesInicio=Septiembre

    $newId = ensureMesExiste($con, $Condominio, $Residencia, $mesCur, $anoCur);
    if ($newId <= 0) break;

    $rN = mysqli_query($con, "SELECT ID, Mes, Ano, InvTotal, Pagorealizado, Pagorestante, Adjuntarimagen, Pagoparcial FROM mantenimientopago WHERE ID=$newId LIMIT 1");
    if (!$rN) break;
    $c = mysqli_fetch_assoc($rN);
    if (!$c) break;

    $rest = dec($c['Pagorestante']);
    if ($rest <= 0) $rest = dec($c['InvTotal']) - dec($c['Pagorealizado']);
    if ($rest <= 0) continue;

    $ap = ($saldo < $rest) ? $saldo : $rest;
    $ap = round($ap, 2);

    $nuevoPagado = round(dec($c['Pagorealizado']) + $ap, 2);
    $nuevoRest   = round($rest - $ap, 2);

    $parcial = ($nuevoRest > 0) ? '1' : '0';
    $estado  = calcStatus($nuevoRest, $c['Adjuntarimagen'], $parcial);

    // Asegurar detalle destino
    $detOk = ensureDetalleExists($con, $newId, $mesCur, $anoCur, $Condominio, $Residencia, $Nombres4, $Apellidos4, $Cuota3);
    if ($detOk !== true) { createTriggerCuotaestatus($con); jexit(false, array('error'=>'Detalle destino (InvID='.$newId.') no existe y no se pudo crear: '.$detOk)); }

    $up = mysqli_query($con, "
      UPDATE mantenimientopago
      SET Pagorealizado = $nuevoPagado,
          Pagorestante  = $nuevoRest,
          Pagoparcial   = '$parcial',
          Pagostatus    = '$estado',
          Fechapago     = '$fechaPago'
      WHERE ID=$newId
      LIMIT 1
    ");
    if (!$up) break;

    $okDet = aplicarEnDetalleDestino($con, $newId, $ap);
    if ($okDet !== true) { createTriggerCuotaestatus($con); jexit(false, array('error'=>"Detalle destino (InvID=$newId) no actualizado: $okDet")); }

    // Línea contable en mes actual (SIEMPRE para meses futuros)
    $Concepto = 'Cuota Basica'; // si quieres diferenciar: 'Pago Adelantado'
    $insLine = insertarLineaMesActual($con, $base_id, $Cuota3, $Concepto, $mesCur, $anoCur, $Condominio, $Residencia, $ap, $Nombres4, $Apellidos4, $Mesactual, $Anoactual);
    if ($insLine !== true) { createTriggerCuotaestatus($con); jexit(false, array('error'=>"No pudo insertar línea en mes actual: $insLine")); }

    $saldo = round($saldo - $ap, 2);
    $aplicado = round($aplicado + $ap, 2);

    $aplicaciones[] = array('ID'=>(string)$newId,'Mes'=>$mesCur,'Ano'=>$anoCur,'Aplicado'=>$ap,'Restante'=>($nuevoRest<0?0:$nuevoRest),'Estado'=>$estado,'linea_mes_actual'=>1);
  }
}

// Restaurar trigger
createTriggerCuotaestatus($con);

jexit(true, array(
  'message'=>'OK: sin duplicar mes actual. Pagó mes actual (si aplica) y creó líneas solo para meses adelantados.',
  'base_id'=>$base_id,
  'mes_actual'=>$Mesactual,
  'ano_actual'=>$Anoactual,
  'mes_inicio'=>$MesInicio,
  'ano_inicio'=>$AnoInicio,
  'aplicado_operativo'=>$aplicado,
  'sobrante'=>$saldo,
  'aplicaciones'=>$aplicaciones
));
