// public/js/admin-unread.js

document.addEventListener('DOMContentLoaded', function () {
    const badge = document.getElementById('adminChatBadge');
    if (!badge) return; // por si en alguna vista no existe

    function updateBadge() {
        // 👈 RUTA ABSOLUTA, fuera de /gestioncomunicacion
        fetch('{{ url("chat-admin.php") }}?action=unread_admin_count')
            .then(r => r.json())
            .then(data => {
                if (data.error) {
                    // console.error('unread_admin_count error:', data);
                    return;
                }

                const total = Number(data.total || 0);

                if (total > 0) {
                    badge.style.display = 'inline-block';
                    badge.textContent   = total > 99 ? '99+' : total;
                } else {
                    badge.style.display = 'none';
                    badge.textContent   = '0';
                }
            })
            .catch(() => {
                // si falla la petición, no rompemos nada
            });
    }

    // Primera carga
    updateBadge();

    // Cada 10 segundos
    setInterval(updateBadge, 10000);
});
