<?php
include 'dbconnection.php';
$ID = $_GET["ID"];
$cuota = mysqli_fetch_array(mysqli_query($con, "SELECT * FROM mantenimientopago WHERE ID = '$ID'"));
$detalle = mysqli_query($con, "SELECT * FROM mantenimientopagodetalle WHERE InvID = '$ID'");
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Cuota de Mantenimiento</title>
  <link href="https://fonts.googleapis.com/css2?family=Poiret+One&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Urbanist';
      background-color: #dbdbdb;
      margin: 0;
      padding: 40px;
    background-image: url('backgroundcuota.png'); /* Replace with your image path */
    background-repeat: no-repeat; /* Prevents the image from repeating */
    background-size: cover; /* Stretches the image to cover the entire viewport */
    background-position: center; /* Centers the image */
    }
    .container {
      background: white;
      width: 750px;
      margin: auto;
      border-radius: 14px;
      padding: 40px;
    }
    .header {
      display: flex;
      align-items: center;
      background-color: #535d6b;
      border-radius: 30px;
      padding: 10px 20px;
      color: white;
    }
    .header img {
      width: 50px;
      margin-right: 20px;
    }
    .header h1 {
      flex: 1;
      font-family: 'Poiret One', cursive;
      font-size: 22px;
      margin: 0;
      text-transform: uppercase;
    }
    .header .cuota-id {
      background-color: #535d6b;
      border: 2px solid #f2c51f;
      color: #f2c51f;
      padding: 4px 12px;
      border-radius: 20px;
      font-size: 14px;
    }
    .title {
      text-align: center;
      font-family: 'Poiret One', cursive;
      font-size: 28px;
      margin: 30px 0 10px;
      
    }
    .section {
      margin-top: 30px;
      border: 1px solid #ccc;
      border-radius: 5px;
      padding: 20px;
    }
    .section h2 {
      font-family: 'Poiret One', cursive;
      font-size: 16px;
      color: #333;
      text-transform: uppercase;
      margin-bottom: 15px;
    }
    table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 6px; /* ← Este valor crea el espacio visible entre celdas */
  
    }
    th {
      background-color: #535d6b;
      color: white;
      padding: 8px;
      font-size: 12px;
      border-radius: 0.27em;
      text-transform: uppercase;
    }
    td {
      background-color: #f5f5f5;
      padding: 8px;
      font-size: 13px;
      text-align: center;
      border-radius: 0.27em;
    }
    .totals td {
     /* background-color: #f5f5f5 !important;*/
      font-weight: bold;
      font-size: 14px;
      
    }
    .totals .label {
      text-align: right;
    }
    .totals .total {
      /*background-color: #f2c51f !important;*/
    }
    .note-box {
      background-color: #f5f5f5;
      border-radius: 10px;
      min-height: 60px;
      padding: 10px;
      font-size: 13px;
      padding:12px 14px;
      min-height:120px;
    }
    
.table {
  
  
}
th, td {
  border-radius: 0.27em;
  /*filter: drop-shadow(0px 0px 1px #444544);*/
  
}

.table tbody tr td {
    border: none !important;
}

 td {
 
  filter: drop-shadow(0px 0px 1px #949494);
  
}
  </style>
</head>
<body>
  <div class="container" id="reporte">
      
   <div style="
                                width:60px;
                                height:60px;
                                border-radius:50%;
                                overflow:hidden;
                                background:#e8e6e6;
                                display:flex;
                                align-items:center;
                                justify-content:center;
                                margin-left: -3px;
                                position:absolute;
                                margin-top: 5px;
                                border: 4px solid #4E5D69;
                            ">
                                <img src="officeimage/cuotamant.png"
                                     alt="Cuota"
                                     style="max-width:100%; max-height:100%; object-fit:cover;">
                            </div>
   
    <div class="header" style="margin-top:14px;">
<?php      
if($cuota['Pagostatus']=='Pagado'){
echo"<div style='position:absolute;margin-left:500px;margin-top:100px'><img class='imagen' style='width: 48%;' src='uploads/images/pagado.png'></div>";
}
else {



}
?>     
      
      
      <h1>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cuota de Mantenimiento</h1>
      <div class="cuota-id">No. <?php echo $ID; ?></div>
    </div>

    <div class="title" style="margin-top:30px;margin-bottom: -10px;"><?php echo strtoupper($cuota['Condominio']); ?></div>

    <div class="section">
      <h2 style="margin-top:-3px; margin-bottom: 8px">Información del Residente</h2>
      <table>
        <thead>
          <tr>
            <th>Nombres</th><th>Apellidos</th><th>Condominio</th><th>Residencia</th><th>Mes</th><th>Año</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo $cuota['Nombres']; ?></td>
            <td><?php echo $cuota['Apellidos']; ?></td>
            <td><?php echo $cuota['Condominio']; ?></td>
            <td><?php echo $cuota['Residencia']; ?></td>
            <td><?php echo $cuota['Mes']; ?></td>
            <td><?php echo $cuota['Ano']; ?></td>
          </tr>
        </tbody>
      </table>
    </div>

    <div class="section">
      <h2 style="margin-top:-3px; margin-bottom: 8px">Conceptos a Facturar</h2>
      <table>
        <thead>
          <tr>
            <th>Concepto a Facturar</th><th>Mes</th><th>Año</th><th>Cantidad</th><th>Sub - Total</th><th>Total</th>
          </tr>
        </thead>
        <tbody>
          <?php
          mysqli_data_seek($detalle, 0);
          while ($row = mysqli_fetch_array($detalle)) {
            $subtotal = number_format($row['Amount'], 2);
            $total = number_format($row['Amount'] * $row['Qty'], 2);
            echo "<tr>
              <td>{$row['Items']}</td>
              <td>{$row['Mes']}</td>
              <td>{$row['Ano']}</td>
              <td>{$row['Qty']}</td>
              <td>$ $subtotal</td>
              <td>$ $total</td>
            </tr>";
          }
          ?>
          <tr class="totals">
            <td colspan="5" class="label">Descuento</td>
            <td>$ <?php echo number_format($cuota['InvDiscount'], 2); ?></td>
          </tr>
          <tr class="totals">
           <td colspan="5" class="label">Total</td>
          <?php
            $status = strtolower(trim($cuota['Pagostatus']));
            $bgcolor = ($status === 'pagado') ? '#b6e37c' : '#f4c94f';
          ?>
          <td style="background:<?= $bgcolor ?>; text-align: center; font-weight:700; font-size:15px;">
            $ <?= number_format($cuota['InvTotal'], 2) ?>
          </td>
          </tr>
        </tbody>
      </table>
    </div>

    <div class="section">
      <h2 style="margin-top:-3px; margin-bottom: 13px" >Notas</h2>
      <div class="note-box"><?php echo nl2br($cuota['Nota']); ?></div>
    </div>
  </div>

  <script src="html2pdf.bundle.min.js"></script>
  <script>
    function downloadPDF() {
      const element = document.getElementById('reporte');
      html2pdf().set({
        margin: -0.1,
        filename: 'Cuota_<?php echo $ID; ?>.pdf',
        image: { type: 'jpeg', quality: 0.98 },
        html2canvas: { scale: 2 },
        jsPDF: { unit: 'in', format: 'letter', orientation: 'portrait' }
      }).from(element).save();
    }
  </script>
  <div style="text-align:center; margin-top: 30px;">
    <button onclick="downloadPDF()" style="padding: 8px 16px; font-size: 14px; background-color: #535d6b; color: white; border: none; border-radius: 8px; cursor: pointer;">
      Descargar PDF
    </button>
  </div>
</body>
</html>
