<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\TwiML\Voice;

use Twilio\TwiML\TwiML;

class Pay extends TwiML {
    /**
     * Pay constructor.
     * 
     * @param array $attributes Optional attributes
     */
    public function __construct($attributes = array()) {
        parent::__construct('Pay', null, $attributes);
    }

    /**
     * Add Prompt child.
     * 
     * @param array $attributes Optional attributes
     * @return TwiML Child element.
     */
    public function prompt($attributes = array()) {
        return $this->nest(new Prompt($attributes));
    }

    /**
     * Add Input attribute.
     * 
     * @param pay:Enum:Input $input Input type Twilio should accept
     * @return $this
     */
    public function setInput($input) {
        return $this->setAttribute('input', $input);
    }

    /**
     * Add Action attribute.
     * 
     * @param url $action Action URL
     * @return $this
     */
    public function setAction($action) {
        return $this->setAttribute('action', $action);
    }

    /**
     * Add StatusCallback attribute.
     * 
     * @param url $statusCallback Status callback URL
     * @return $this
     */
    public function setStatusCallback($statusCallback) {
        return $this->setAttribute('statusCallback', $statusCallback);
    }

    /**
     * Add StatusCallbackMethod attribute.
     * 
     * @param pay:Enum:StatusCallbackMethod $statusCallbackMethod Status callback
     *                                                            method
     * @return $this
     */
    public function setStatusCallbackMethod($statusCallbackMethod) {
        return $this->setAttribute('statusCallbackMethod', $statusCallbackMethod);
    }

    /**
     * Add Timeout attribute.
     * 
     * @param integer $timeout Time to wait to gather input
     * @return $this
     */
    public function setTimeout($timeout) {
        return $this->setAttribute('timeout', $timeout);
    }

    /**
     * Add MaxAttempts attribute.
     * 
     * @param integer $maxAttempts Maximum number of allowed retries when gathering
     *                             input
     * @return $this
     */
    public function setMaxAttempts($maxAttempts) {
        return $this->setAttribute('maxAttempts', $maxAttempts);
    }

    /**
     * Add SecurityCode attribute.
     * 
     * @param boolean $securityCode Prompt for security code
     * @return $this
     */
    public function setSecurityCode($securityCode) {
        return $this->setAttribute('securityCode', $securityCode);
    }

    /**
     * Add PostalCode attribute.
     * 
     * @param string $postalCode Prompt for postal code and it should be true/false
     *                           or default postal code
     * @return $this
     */
    public function setPostalCode($postalCode) {
        return $this->setAttribute('postalCode', $postalCode);
    }

    /**
     * Add PaymentConnector attribute.
     * 
     * @param string $paymentConnector Unique name for payment connector
     * @return $this
     */
    public function setPaymentConnector($paymentConnector) {
        return $this->setAttribute('paymentConnector', $paymentConnector);
    }

    /**
     * Add TokenType attribute.
     * 
     * @param pay:Enum:TokenType $tokenType Type of token
     * @return $this
     */
    public function setTokenType($tokenType) {
        return $this->setAttribute('tokenType', $tokenType);
    }

    /**
     * Add ChargeAmount attribute.
     * 
     * @param string $chargeAmount Amount to process. If value is greater than 0
     *                             then make the payment else create a payment token
     * @return $this
     */
    public function setChargeAmount($chargeAmount) {
        return $this->setAttribute('chargeAmount', $chargeAmount);
    }

    /**
     * Add Currency attribute.
     * 
     * @param string $currency Currency of the amount attribute
     * @return $this
     */
    public function setCurrency($currency) {
        return $this->setAttribute('currency', $currency);
    }

    /**
     * Add Description attribute.
     * 
     * @param string $description Details regarding the payment
     * @return $this
     */
    public function setDescription($description) {
        return $this->setAttribute('description', $description);
    }

    /**
     * Add ValidCardTypes attribute.
     * 
     * @param pay:Enum:ValidCardTypes $validCardTypes Comma separated accepted card
     *                                                types
     * @return $this
     */
    public function setValidCardTypes($validCardTypes) {
        return $this->setAttribute('validCardTypes', $validCardTypes);
    }

    /**
     * Add Language attribute.
     * 
     * @param pay:Enum:Language $language Language to use
     * @return $this
     */
    public function setLanguage($language) {
        return $this->setAttribute('language', $language);
    }
}