<?php

	/*Database Connection*/
	include '../../dbconnection.php';
    $con->set_charset('utf8');
	/*include PhpSpreadsheet library*/
	require 'PhpSpreadsheet/vendor/autoload.php';

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
	use PhpOffice\PhpSpreadsheet\Writer\Xls;	
	use PhpOffice\PhpSpreadsheet\Style\Alignment;
	use PhpOffice\PhpSpreadsheet\Style\Fill;
	use PhpOffice\PhpSpreadsheet\Style\Color;
	use PhpOffice\PhpSpreadsheet\Style\Border;
	use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
	use PhpOffice\PhpSpreadsheet\Style\Protection;
	use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;
	use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
	use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
	use PhpOffice\PhpSpreadsheet\Worksheet\Row;
	use PhpOffice\PhpSpreadsheet\Calculation\Calculation;
	use PhpOffice\PhpSpreadsheet\Cell\Cell;
	use PhpOffice\PhpSpreadsheet\Cell\DataValidation;	
	use PhpOffice\PhpSpreadsheet\IOFactory;


	$spreadsheet = new Spreadsheet();

    $ID= $_GET["id"];

    $Q= mysqli_query($con,"SELECT Condominio,Total FROM presupuesto WHERE PresupuestoID = '$ID'");
    $row1 = mysqli_fetch_assoc($Q);
    $Condominio = $row1 ['Condominio'];
    $Total = $row1 ['Total'];



	/*Page Setup
	Page Orientation(ORIENTATION_LANDSCAPE/ORIENTATION_PORTRAIT), 
	Paper Size(PAPERSIZE_A3,PAPERSIZE_A4,PAPERSIZE_A5,PAPERSIZE_LETTER,PAPERSIZE_LEGAL etc)*/
	$spreadsheet->getActiveSheet()->getPageSetup()->setOrientation(PageSetup::ORIENTATION_PORTRAIT);
	$spreadsheet->getActiveSheet()->getPageSetup()->setPaperSize(PageSetup::PAPERSIZE_A4);


	/*Set Page Margins for a Worksheet*/
	$spreadsheet->getActiveSheet()->getPageMargins()->setTop(0.75);
	$spreadsheet->getActiveSheet()->getPageMargins()->setRight(0.75);
	$spreadsheet->getActiveSheet()->getPageMargins()->setLeft(1.10);
	$spreadsheet->getActiveSheet()->getPageMargins()->setBottom(0.75);

	/*Center a page horizontally/vertically*/
	$spreadsheet->getActiveSheet()->getPageSetup()->setHorizontalCentered(true);
	$spreadsheet->getActiveSheet()->getPageSetup()->setVerticalCentered(false);

	/*Show/hide gridlines(true/false)*/
	$spreadsheet->getActiveSheet()->setShowGridlines(true);

	//Activate work sheet
    $spreadsheet->createSheet(0);
    $spreadsheet->setActiveSheetIndex(0);
	$spreadsheet->getActiveSheet(0);
	//work sheet name
    $spreadsheet->getActiveSheet()->setTitle('Presupuesto');	
	/*Default Font Set*/
	$spreadsheet->getDefaultStyle()->getFont()->setName('Calibri');
	/*Default Font Size Set*/
	$spreadsheet->getDefaultStyle()->getFont()->setSize(11); 

	/*Border color*/
    $styleThinBlackBorderOutline = array('borders' => array('outline'=> array('borderStyle' => Border::BORDER_THIN, 'color' => array('argb' => '5a5a5a'))));
	$spreadsheet->getActiveSheet()->SetCellValue('A1', 'Presupuesto Actual');
	$spreadsheet->getActiveSheet()->SetCellValue('A2', 'Condominio : '. $Condominio);
	$spreadsheet->getActiveSheet()->SetCellValue('A3', 'Total-Presupuesto : $'. $Total);
	$spreadsheet->getActiveSheet()->getStyle('A2')->getFont();
	/*Font Size for Cells*/
	$spreadsheet -> getActiveSheet()->getStyle('A2') -> applyFromArray(array('font' => array('size' => '18', 'bold' => true)), 'A2');
    $spreadsheet -> getActiveSheet()->getStyle('A1') -> applyFromArray(array('font' => array('size' => '23', 'bold' => true)), 'A2');
    $spreadsheet -> getActiveSheet()->getStyle('A3') -> applyFromArray(array('font' => array( 'color' => array('rgb' => 'ffffff'),'size' => '13', 'bold' => true)), 'A3');
	/*Text Alignment Horizontal(HORIZONTAL_LEFT,HORIZONTAL_CENTER,HORIZONTAL_RIGHT)*/
	$spreadsheet -> getActiveSheet()->getStyle('A2') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
	$spreadsheet -> getActiveSheet()->getStyle('A3') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
	$spreadsheet -> getActiveSheet()->getStyle('A1') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
	/*Text Alignment Vertical(VERTICAL_TOP,VERTICAL_CENTER,VERTICAL_BOTTOM)*/
	$spreadsheet -> getActiveSheet() -> getStyle('A1')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	$spreadsheet -> getActiveSheet() -> getStyle('A2')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	$spreadsheet -> getActiveSheet() -> getStyle('A3')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	/*merge Cell*/
	$spreadsheet -> getActiveSheet() -> mergeCells('A1:B1');
	$spreadsheet -> getActiveSheet() -> mergeCells('A2:B2');
	$spreadsheet -> getActiveSheet() -> mergeCells('A3:B3');

	/*Fill Color Change function for Cells*/
	cellColor('A1:B2', 'd9e1ec');
	cellColor('A3:B3', '346982');
	cellColor('A4:B4', '9ab1d1');

	/*Value Set for Cells*/
    $spreadsheet -> getActiveSheet()				
				->SetCellValue('A4', 'Subcategoria')							
				->SetCellValue('B4', 'Cantidad');
				

	/*Font Size for Cells*/
	$spreadsheet -> getActiveSheet()->getStyle('A4') -> applyFromArray(array('font' => array('size' => '12', 'bold' => true)), 'A4');	
	$spreadsheet -> getActiveSheet()->getStyle('B4') -> applyFromArray(array('font' => array('size' => '12', 'bold' => true)), 'B4');
	//$spreadsheet -> getActiveSheet()->getStyle('C4') -> applyFromArray(array('font' => array('size' => '12', 'bold' => true)), 'C4');
	//$spreadsheet -> getActiveSheet()->getStyle('D4') -> applyFromArray(array('font' => array('size' => '12', 'bold' => true)), 'D4');
	//$spreadsheet -> getActiveSheet()->getStyle('E4') -> applyFromArray(array('font' => array('size' => '12', 'bold' => true)), 'E4');

	/*Text Alignment Horizontal(HORIZONTAL_LEFT,HORIZONTAL_CENTER,HORIZONTAL_RIGHT)*/
	$spreadsheet -> getActiveSheet()->getStyle('A4') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
	$spreadsheet -> getActiveSheet()->getStyle('B4') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
	//$spreadsheet -> getActiveSheet()->getStyle('C4') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);
	//$spreadsheet -> getActiveSheet()->getStyle('D4') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
	//$spreadsheet -> getActiveSheet()->getStyle('E4') -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);

	/*Text Alignment Vertical(VERTICAL_TOP,VERTICAL_CENTER,VERTICAL_BOTTOM)*/
	$spreadsheet -> getActiveSheet() -> getStyle('A4')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	$spreadsheet -> getActiveSheet() -> getStyle('B4')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	//$spreadsheet -> getActiveSheet() -> getStyle('C4')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	//$spreadsheet -> getActiveSheet() -> getStyle('D4')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
	//$spreadsheet -> getActiveSheet() -> getStyle('E4')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);

	/*Width for Cells*/
	$spreadsheet -> getActiveSheet() -> getColumnDimension('A') -> setWidth(40);
	$spreadsheet -> getActiveSheet() -> getColumnDimension('B') -> setWidth(40);
	//$spreadsheet -> getActiveSheet() -> getColumnDimension('C') -> setWidth(20);
	//$spreadsheet -> getActiveSheet() -> getColumnDimension('D') -> setWidth(20);
	//$spreadsheet -> getActiveSheet() -> getColumnDimension('E') -> setWidth(20);
	/*Wrap text*/
	$spreadsheet->getActiveSheet()->getStyle('A4')->getAlignment()->setWrapText(true);

	/*border color set for cells*/
	$spreadsheet -> getActiveSheet() -> getStyle('A4:A4') -> applyFromArray($styleThinBlackBorderOutline);
	$spreadsheet -> getActiveSheet() -> getStyle('B4:B4') -> applyFromArray($styleThinBlackBorderOutline);
	//$spreadsheet -> getActiveSheet() -> getStyle('C4:C4') -> applyFromArray($styleThinBlackBorderOutline);
	//$spreadsheet -> getActiveSheet() -> getStyle('D4:D4') -> applyFromArray($styleThinBlackBorderOutline);
	//$spreadsheet -> getActiveSheet() -> getStyle('E4:E4') -> applyFromArray($styleThinBlackBorderOutline);

	/*sql*/
    $sql1 = mysqli_query($con,"SELECT * FROM detallespresupuesto  GROUP BY Categoriacosto");
    $cuenta = mysqli_num_rows($sql1);
    while($row2 = mysqli_fetch_array($sql1) ){
      
      $Categoria[] = $row2['Categoriacosto'];
      }
     
    $j=5;
	$tempDate = ''; 
    $rcount = 0;
    $subtotal = 0;

	for($i=0;$i<$cuenta;$i++){
    
	$sql = "SELECT  Subcategoriacosto,Categoriacosto,Cantidad
	FROM detallespresupuesto WHERE DetallesID = '$ID' AND Categoriacosto ='".$Categoria[$i]."';";
	$result = mysqli_query($con, $sql);

	while ($aRow = mysqli_fetch_array($result)) {
		
		if ($tempDate!=$aRow['Categoriacosto']) {
			/*SUB TOTAL*/
			if($rcount>0){
				$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j) -> applyFromArray($styleThinBlackBorderOutline);
				$spreadsheet->getActiveSheet()->getStyle('A' . $j . ':B' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('bfbfbf');
				$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);

				//$spreadsheet -> getActiveSheet() -> mergeCells('A' . $j . ':C' . $j);
				$spreadsheet -> getActiveSheet() -> SetCellValue('A' . $j, 'SUB TOTAL');
				//$spreadsheet -> getActiveSheet() -> getStyle('D' . $j . ':D' . $j) -> applyFromArray($styleThinBlackBorderOutline);
				//$spreadsheet->getActiveSheet()->getStyle('D' . $j . ':D' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('bfbfbf');
				//$spreadsheet -> getActiveSheet() -> getStyle('D' . $j . ':D' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
				$spreadsheet -> getActiveSheet() -> SetCellValue('B' . $j, $subtotal);
				$spreadsheet -> getActiveSheet() -> getStyle('B' . $j, $subtotal)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
				$spreadsheet->getActiveSheet()->getStyle('B' . $j, $subtotal)->getFont()->setSize(12)->setBold(true); 
				
				//$spreadsheet -> getActiveSheet() -> getStyle('E' . $j . ':E' . $j) -> applyFromArray($styleThinBlackBorderOutline);
				//$spreadsheet->getActiveSheet()->getStyle('E' . $j . ':E' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('bfbfbf');
				//$spreadsheet -> getActiveSheet() -> getStyle('E' . $j . ':E' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
				$spreadsheet -> getActiveSheet() -> SetCellValue('E' . $j++, '');
				
				/*Number format Cell D*/
				$spreadsheet->getActiveSheet()->getStyle('B'.$j)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
				$spreadsheet->getActiveSheet()->getStyle('B'.$j)->getNumberFormat()->setFormatCode('$ #,##0.00'); 
			}
			
			/*Group*/
			$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j) -> applyFromArray($styleThinBlackBorderOutline);
			$spreadsheet->getActiveSheet()->getStyle('A' . $j . ':B' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('e29e38');
			$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
			$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
			$spreadsheet->getActiveSheet()->getStyle('A' . $j . ':B' . $j)->getFont()->setSize(12)->setBold(true); 
			$spreadsheet -> getActiveSheet() -> mergeCells('A' . $j . ':B' . $j);
			$spreadsheet -> getActiveSheet() -> SetCellValue('A' . $j++, utf8_encode($aRow['Categoriacosto']));

			$tempDate=utf8_encode($aRow['Categoriacosto']);
			$subtotal=$aRow['Cantidad'];
		}else

		{
			
			$subtotal+=$aRow['Cantidad'];
			
		}

		/*Value Set for Cells*/
		$spreadsheet->getActiveSheet()
				
					->SetCellValue('A'.$j, $aRow['Subcategoriacosto'])	
					->SetCellValue('B'.$j, $aRow['Cantidad']);																
					

		/*border color set for cells*/	
		$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':A' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		$spreadsheet -> getActiveSheet() -> getStyle('B' . $j . ':B' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		//$spreadsheet -> getActiveSheet() -> getStyle('C' . $j . ':C' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		//$spreadsheet -> getActiveSheet() -> getStyle('D' . $j . ':D' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		//$spreadsheet -> getActiveSheet() -> getStyle('E' . $j . ':E' . $j) -> applyFromArray($styleThinBlackBorderOutline);

		/*Text Alignment Horizontal(HORIZONTAL_LEFT,HORIZONTAL_CENTER,HORIZONTAL_RIGHT)*/
		$spreadsheet -> getActiveSheet()->getStyle('A' . $j . ':A' . $j) -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
		$spreadsheet -> getActiveSheet()->getStyle('B' . $j . ':B' . $j) -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
		//$spreadsheet -> getActiveSheet()->getStyle('C' . $j . ':C' . $j) -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);
		//$spreadsheet -> getActiveSheet()->getStyle('D' . $j . ':D' . $j) -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
		//$spreadsheet -> getActiveSheet()->getStyle('E' . $j . ':E' . $j) -> getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);

		/*Text Alignment Vertical(VERTICAL_TOP,VERTICAL_CENTER,VERTICAL_BOTTOM)*/
		$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':A' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		$spreadsheet -> getActiveSheet() -> getStyle('B' . $j . ':B' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		//$spreadsheet -> getActiveSheet() -> getStyle('C' . $j . ':C' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		//$spreadsheet -> getActiveSheet() -> getStyle('D' . $j . ':D' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		//$spreadsheet -> getActiveSheet() -> getStyle('E' . $j . ':E' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);

		/*Number format Cell D*/
		$spreadsheet->getActiveSheet()->getStyle('B'.$j)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$spreadsheet->getActiveSheet()->getStyle('B'.$j)->getNumberFormat()->setFormatCode('$ #,##0.00'); 
		
		/*Number format Cell E*/
		//$spreadsheet->getActiveSheet()->getStyle('E'.$j)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		//$spreadsheet->getActiveSheet()->getStyle('E'.$j)->getNumberFormat()->setFormatCode('#,##0'); 

		if ($j % 2 == 0) {
			cellColor('A'.$j.':B'.$j, 'f4f8fb');
		}
		
		//$i++; 

		$j++;
		$rcount ++;

		/*Number format Cell D*/
		$spreadsheet->getActiveSheet()->getStyle('B'.$j)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
		$spreadsheet->getActiveSheet()->getStyle('B'.$j)->getNumberFormat()->setFormatCode('$ #,##0.00');		
	}
	
	/*SUB TOTAL*/
	if($rcount>0){
		$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		$spreadsheet->getActiveSheet()->getStyle('A' . $j . ':B' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('bfbfbf');
		$spreadsheet -> getActiveSheet() -> getStyle('A' . $j . ':B' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		//$spreadsheet -> getActiveSheet() -> mergeCells('A' . $j . ':C' . $j);
		$spreadsheet -> getActiveSheet() -> SetCellValue('A' . $j, 'SUB TOTAL');
		
		//$spreadsheet -> getActiveSheet() -> getStyle('D' . $j . ':D' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		//$spreadsheet->getActiveSheet()->getStyle('D' . $j . ':D' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('bfbfbf');
		//$spreadsheet -> getActiveSheet() -> getStyle('D' . $j . ':D' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		$spreadsheet -> getActiveSheet() -> SetCellValue('B' . $j,$subtotal);
		
		$spreadsheet -> getActiveSheet() -> getStyle('B' . $j,$subtotal)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
		$spreadsheet->getActiveSheet()->getStyle('B' . $j,$subtotal)->getFont()->setSize(12)->setBold(true); 


		
		//$spreadsheet -> getActiveSheet() -> getStyle('E' . $j . ':E' . $j) -> applyFromArray($styleThinBlackBorderOutline);
		//$spreadsheet->getActiveSheet()->getStyle('E' . $j . ':E' . $j)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('bfbfbf');
		//$spreadsheet -> getActiveSheet() -> getStyle('E' . $j . ':E' . $j)->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
		//$spreadsheet -> getActiveSheet() -> SetCellValue('D' . $j++, '');
	}
	} 
    
     
			
	if (function_exists('date_default_timezone_set')) {
			date_default_timezone_set('UTC');
	} else {
			putenv("AU=UTC");
	}

	$exportTime = date("Y-m-d-His", time());
	/* $writer = new Xls($spreadsheet);
	$file = 'row-grouping-'.$exportTime. '.xls'; //Save file name */	
	$writer = new Xlsx($spreadsheet);
	$file = 'Presupuestos-'.$Condominio.'.xlsx'; //Save file name
	$writer->save('Presupuestos-'.$Condominio.'.xlsx');
	header("Location:Presupuestos-".$Condominio.".xlsx"); //File open location

	function cellColor($cells, $color) {
		global $spreadsheet;
		$spreadsheet->getActiveSheet()->getStyle($cells)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB($color);

	}

	

?>