@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> Form  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">

	{!! Form::open(array('url'=>'localizacionesreserva?return='.$return, 'class'=>'form-horizontal validated','files' => true )) !!}
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools " >
				<a href="{{ url($pageModule.'?return='.$return) }}" class="tips btn btn-sm "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-times"></i></a> 
			</div>
			<div class="sbox-tools pull-left" >
				<button name="apply" class="tips btn btn-sm btn-apply  "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-check"></i> {{ __('core.sb_apply') }} </button>
				<button name="save" class="tips btn btn-sm btn-save"  title="{{ __('core.btn_back') }}" ><i class="fa  fa-paste"></i> {{ __('core.sb_save') }} </button> 
			</div>
		</div>	
		<div class="sbox-content clearfix">
	<ul class="parsley-error-list">
		@foreach($errors->all() as $error)
			<li>{{ $error }}</li>
		@endforeach
	</ul>		
<div class="col-md-12">
						<fieldset><legend> Areas a Reservar</legend>
				{!! Form::hidden('LocalizacionID', $row['LocalizacionID']) !!}					
									  <div class="form-group  " >
										<label for="Nombre" class=" control-label col-md-4 text-left"> Nombre <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Nombre' id='Nombre' value='{{ $row['Nombre'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Descripcion" class=" control-label col-md-4 text-left"> Descripcion </label>
										<div class="col-md-6">
										  <textarea name='Descripcion' rows='5' id='Descripcion' class='form-control input-sm '  
				         required  >{{ $row['Descripcion'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Condominio" class=" control-label col-md-4 text-left"> Condominio <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Condominio' rows='5' id='Condominio' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Tipo de Localizacion" class=" control-label col-md-4 text-left"> Tipo de Localizacion </label>
										<div class="col-md-6">
										  <select name='Localizacion' rows='5' id='Localizacion' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Pago" class=" control-label col-md-4 text-left"> Pago <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
					<?php $Pago = explode(',',$row['Pago']);
					$Pago_opt = array( 'No' => 'No' ,  'Si' => 'Si' , ); ?>
					<select name='Pago' rows='5'   class='select2 '  > 
						<?php 
						foreach($Pago_opt as $key=>$val)
						{
							echo "<option  value ='$key' ".($row['Pago'] == $key ? " selected='selected' " : '' ).">$val</option>"; 						
						}						
						?></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Cantidad" class=" control-label col-md-4 text-left"> Cantidad <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Cantidad' id='Cantidad' value='{{ $row['Cantidad'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Status" class=" control-label col-md-4 text-left"> Status <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='Status' rows='5' id='Status' class='form-control input-sm '  
				           >{{ $row['Status'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> </fieldset>
			</div>
			
			

		</div>
	</div>
	<input type="hidden" name="action_task" value="save" />
	{!! Form::close() !!}
	</div>
</div>		
	
		 
   <script type="text/javascript">
	$(document).ready(function() { 
		
		
		
		$("#Localizacion").jCombo("{!! url('localizacionesreserva/comboselect?filter=tipodelocalizacion:Localizacion:Localizacion') !!}",
		{  selected_value : '{{ $row["Localizacion"] }}' });
		
		$("#Condominio").jCombo("{!! url('localizacionesreserva/comboselect?filter=condominios:Nombre:Nombre') !!}",
		{  selected_value : '{{ $row["Condominio"] }}' });
		 		 

		$('.removeMultiFiles').on('click',function(){
			var removeUrl = '{{ url("localizacionesreserva/removefiles?file=")}}'+$(this).attr('url');
			$(this).parent().remove();
			$.get(removeUrl,function(response){});
			$(this).parent('div').empty();	
			return false;
		});		
		
	});
	</script>		 
@stop