@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> Form  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">

	{!! Form::open(array('url'=>'servicioalcliente?return='.$return, 'class'=>'form-horizontal validated','files' => true )) !!}
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools " >
				<a href="{{ url($pageModule.'?return='.$return) }}" class="tips btn btn-sm "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-times"></i></a> 
			</div>
			<div class="sbox-tools pull-left" >
				<button name="apply" class="tips btn btn-sm btn-apply  "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-check"></i> {{ __('core.sb_apply') }} </button>
				<button name="save" class="tips btn btn-sm btn-save"  title="{{ __('core.btn_back') }}" ><i class="fa  fa-paste"></i> {{ __('core.sb_save') }} </button> 
			</div>
		</div>	
		<div class="sbox-content clearfix">
	<ul class="parsley-error-list">
		@foreach($errors->all() as $error)
			<li>{{ $error }}</li>
		@endforeach
	</ul>		
<div class="col-md-12">
						<fieldset><legend> Evnvio de Comprobante de Pago</legend>
				{!! Form::hidden('ServicioID', $row['ServicioID']) !!}					
									  <div class="form-group  " >
										<label for="Email" class=" control-label col-md-4 text-left"> Email <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Email' id='Email' value='{{ $row['Email'] }}' 
						required     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Condominio" class=" control-label col-md-4 text-left"> Condominio <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Condominio' rows='5' id='Condominio' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Mes" class=" control-label col-md-4 text-left"> Mes <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Mes[]' multiple rows='5' id='Mes' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Ano" class=" control-label col-md-4 text-left"> Ano <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Ano' rows='5' id='Ano' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Cantidadpago" class=" control-label col-md-4 text-left"> Cantidadpago <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Cantidadpago' id='Cantidadpago' value='{{ $row['Cantidadpago'] }}' 
						required     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Adjuntar Imagen" class=" control-label col-md-4 text-left"> Adjuntar Imagen <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='file' name='Adjuntarimagen' id='Adjuntarimagen' class='inputfile  @if($row['Adjuntarimagen'] =='') class='required' @endif '  />

							<label for='Adjuntarimagen'><i class='fa fa-upload'></i> Choose a file</label>
							<div class='Adjuntarimagen_preview'></div>
					 	<div >
						{!! SiteHelpers::showUploadedFile($row['Adjuntarimagen'],'/uploads/comprobantes/') !!}
						
						</div>					
					 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Comentarios" class=" control-label col-md-4 text-left"> Comentarios <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='Comentarios' rows='5' id='Comentarios' class='form-control input-sm '  
				           >{{ $row['Comentarios'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> </fieldset>
			</div>
			
			

		</div>
	</div>
	<input type="hidden" name="action_task" value="save" />
	{!! Form::close() !!}
	</div>
</div>		
	
		 
   <script type="text/javascript">
	$(document).ready(function() { 
		
		
		
		$("#Condominio").jCombo("{!! url('servicioalcliente/comboselect?filter=residentes:Condominio:Condominio') !!}&parent=Email:",
		{  parent: '#Email', selected_value : '{{ $row["Condominio"] }}' });
		
		$("#Mes").jCombo("{!! url('servicioalcliente/comboselect?filter=mes:Mes:Mes') !!}",
		{  selected_value : '{{ $row["Mes"] }}' });
		
		$("#Ano").jCombo("{!! url('servicioalcliente/comboselect?filter=año:ano:ano') !!}",
		{  selected_value : '{{ $row["Ano"] }}' });
		 		 

		$('.removeMultiFiles').on('click',function(){
			var removeUrl = '{{ url("servicioalcliente/removefiles?file=")}}'+$(this).attr('url');
			$(this).parent().remove();
			$.get(removeUrl,function(response){});
			$(this).parent('div').empty();	
			return false;
		});		
		
	});
	</script>		 
@stop