@extends('layouts.app')

@section('content')
<section class="page-header row">
	<h2> {{ $pageTitle }} <small> {{ $pageNote }} </small></h2>
	<ol class="breadcrumb">
		<li><a href="{{ url('') }}"> Dashboard </a></li>
		<li><a href="{{ url($pageModule) }}"> {{ $pageTitle }} </a></li>
		<li class="active"> Form  </li>		
	</ol>
</section>
<div class="page-content row">
	<div class="page-content-wrapper no-margin">

	{!! Form::open(array('url'=>'programaciondeactividades?return='.$return, 'class'=>'form-horizontal validated','files' => true )) !!}
	<div class="sbox">
		<div class="sbox-title clearfix">
			<div class="sbox-tools " >
				<a href="{{ url($pageModule.'?return='.$return) }}" class="tips btn btn-sm "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-times"></i></a> 
			</div>
			<div class="sbox-tools pull-left" >
				<button name="apply" class="tips btn btn-sm btn-apply  "  title="{{ __('core.btn_back') }}" ><i class="fa  fa-check"></i> {{ __('core.sb_apply') }} </button>
				<button name="save" class="tips btn btn-sm btn-save"  title="{{ __('core.btn_back') }}" ><i class="fa  fa-paste"></i> {{ __('core.sb_save') }} </button> 
			</div>
		</div>	
		<div class="sbox-content clearfix">
	<ul class="parsley-error-list">
		@foreach($errors->all() as $error)
			<li>{{ $error }}</li>
		@endforeach
	</ul>		
<div class="col-md-12">
						<fieldset><legend> Información General</legend>
				{!! Form::hidden('id', $row['id']) !!}					
									  <div class="form-group  " >
										<label for="Tipo de Actividad" class=" control-label col-md-4 text-left"> Tipo de Actividad <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='title' rows='5' id='title' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Condominio" class=" control-label col-md-4 text-left"> Condominio <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Condominio' rows='5' id='Condominio' class='select2 ' required  ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Residencia" class=" control-label col-md-4 text-left"> Residencia <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Residencia' rows='5' id='Residencia' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Description" class=" control-label col-md-4 text-left"> Description <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='description' rows='5' id='description' class='form-control input-sm '  
				           >{{ $row['description'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Estatus" class=" control-label col-md-4 text-left"> Estatus <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
					<?php $status = explode(',',$row['status']);
					$status_opt = array( 'Programar Actividad' => 'Programar Actividad' ,  'No Completada' => 'No Completada' ,  'Completada' => 'Completada' , ); ?>
					<select name='status' rows='5'   class='select2 '  > 
						<?php 
						foreach($status_opt as $key=>$val)
						{
							echo "<option  value ='$key' ".($row['status'] == $key ? " selected='selected' " : '' ).">$val</option>"; 						
						}						
						?></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Fechadeinicio" class=" control-label col-md-4 text-left"> Fechadeinicio <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
				<div class="input-group m-b" style="width:150px !important;">
					{!! Form::text('fechadeinicio', $row['fechadeinicio'],array('class'=>'form-control input-sm datetime', 'style'=>'width:150px !important;')) !!}
					<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
				</div>
				 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Fechafinal" class=" control-label col-md-4 text-left"> Fechafinal <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  
				<div class="input-group m-b" style="width:150px !important;">
					{!! Form::text('fechafinal', $row['fechafinal'],array('class'=>'form-control input-sm datetime', 'style'=>'width:150px !important;')) !!}
					<span class="input-group-addon"><i class="fa fa-calendar"></i></span>
				</div>
				 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Cantidad" class=" control-label col-md-4 text-left"> Cantidad <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <input  type='text' name='Cantidad' id='Cantidad' value='{{ $row['Cantidad'] }}' 
						     class='form-control input-sm ' /> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Vias" class=" control-label col-md-4 text-left"> Vias <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='vias[]' multiple rows='5' id='vias' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Datos" class=" control-label col-md-4 text-left"> Datos <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <textarea name='Datos' rows='5' id='Datos' class='form-control input-sm '  
				           >{{ $row['Datos'] }}</textarea> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> 					
									  <div class="form-group  " >
										<label for="Asignado" class=" control-label col-md-4 text-left"> Asignado <span class="asterix"> * </span></label>
										<div class="col-md-6">
										  <select name='Asignado' rows='5' id='Asignado' class='select2 '   ></select> 
										 </div> 
										 <div class="col-md-2">
										 	
										 </div>
									  </div> </fieldset>
			</div>
			
			

		</div>
	</div>
	<input type="hidden" name="action_task" value="save" />
	{!! Form::close() !!}
	</div>
</div>		
	
		 
   <script type="text/javascript">
	$(document).ready(function() { 
		
		
		
		$("#title").jCombo("{!! url('programaciondeactividades/comboselect?filter=tipodeactividad:Tipo:Tipo') !!}",
		{  selected_value : '{{ $row["title"] }}' });
		
		$("#Condominio").jCombo("{!! url('programaciondeactividades/comboselect?filter=condominios:Nombre:Nombre') !!}",
		{  selected_value : '{{ $row["Condominio"] }}' });
		
		$("#Residencia").jCombo("{!! url('programaciondeactividades/comboselect?filter=residencia:Nombre:Nombre') !!}&parent=Condominio:",
		{  parent: '#Condominio', selected_value : '{{ $row["Residencia"] }}' });
		
		$("#vias").jCombo("{!! url('programaciondeactividades/comboselect?filter=vias:Tipo:Tipo') !!}",
		{  selected_value : '{{ $row["vias"] }}' });
		
		$("#Asignado").jCombo("{!! url('programaciondeactividades/comboselect?filter=supervisores:Email:Email') !!}",
		{  selected_value : '{{ $row["Asignado"] }}' });
		 		 

		$('.removeMultiFiles').on('click',function(){
			var removeUrl = '{{ url("programaciondeactividades/removefiles?file=")}}'+$(this).attr('url');
			$(this).parent().remove();
			$.get(removeUrl,function(response){});
			$(this).parent('div').empty();	
			return false;
		});		
		
	});
	</script>		 
@stop