<?php namespace App\Http\Controllers;
use DB;
use Carbon\Carbon;
use App\Models\Reservacionesadmin;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use Validator, Input, Redirect ; 


class ReservacionesadminController extends Controller {

	protected $layout = "layouts.main";
	protected $data = array();	
	public $module = 'reservacionesadmin';
	static $per_page	= '50';

	public function __construct()
	{		
		parent::__construct();
		$this->model = new Reservacionesadmin();	
		
		$this->info = $this->model->makeInfo( $this->module);	
		$this->data = array(
			'pageTitle'	=> 	$this->info['title'],
			'pageNote'	=>  $this->info['note'],
			'pageModule'=> 'reservacionesadmin',
			'return'	=> self::returnUrl()
			
		);
		
	}

	public function index( Request $request )
	{
		// Make Sure users Logged 
		if(!\Auth::check()) 
			return redirect('user/login')->with('status', 'error')->with('message','You are not login');
		$this->grab( $request) ;
		if($this->access['is_view'] ==0) 
			return redirect('dashboard')->with('message', __('core.note_restric'))->with('status','error');				
		// Render into template
		return view( $this->module.'.index',$this->data);
	}	

	function create( Request $request , $id =0 ) 
	{
		$this->hook( $request  );
		if($this->access['is_add'] ==0) 
			return redirect('dashboard')->with('message', __('core.note_restric'))->with('status','error');

		$this->data['row'] = $this->model->getColumnTable( $this->info['table']); 
		
		$this->data['id'] = '';
		return view($this->module.'.form',$this->data);
	}
	function edit( Request $request , $id ) 
	{
		$this->hook( $request , $id );
		if(!isset($this->data['row']))
			return redirect($this->module)->with('message','Record Not Found !')->with('status','error');
		if($this->access['is_edit'] ==0 )
			return redirect('dashboard')->with('message',__('core.note_restric'))->with('status','error');
		$this->data['row'] = (array) $this->data['row'];
		
		$this->data['id'] = $id;
		return view($this->module.'.form',$this->data);
	}	
	function show( Request $request , $id ) 
	{
		/* Handle import , export and view */
		$task =$id ;
		switch( $task)
		{
			case 'search':
				return $this->getSearch();
				break;
			case 'lookup':
				return $this->getLookup($request );
				break;
			case 'comboselect':
				return $this->getComboselect( $request );
				break;
			case 'import':
				return $this->getImport( $request );
				break;
			case 'export':
				return $this->getExport( $request );
				break;
			default:
				$this->hook( $request , $id );
				if(!isset($this->data['row']))
					return redirect($this->module)->with('message','Record Not Found !')->with('status','error');

				if($this->access['is_detail'] ==0) 
					return redirect('dashboard')->with('message', __('core.note_restric'))->with('status','error');

				return view($this->module.'.view',$this->data);	
				break;		
		}
	}
	function store( Request $request  )
	{
		$task = $request->input('action_task');
		switch ($task)
		{
			default:
				$rules = $this->validateForm();
				$validator = Validator::make($request->all(), $rules);
				if ($validator->passes()) 
				{
					$data = $this->validatePost( $request );
					$id = $this->model->insertRow($data , $request->input( $this->info['key']));
					
					
				$Condominiox= DB::table('calendar')->select('Condominio')
				                                  ->where('id','=', $id)
				                                  ->value(DB::raw("Condominio"));
				                                  
				$Residenciax= DB::table('calendar')->select('Residencia')
				                                  ->where('id','=', $id)
				                                  ->value(DB::raw("Residencia"));	
					
				$Nombres = DB::table('residentes')->select('Nombres')
				                                  ->where('Condominio','=',$Condominiox)
				                                  ->where('Residencia','=',$Residenciax)
				                                  ->value(DB::raw("Nombres"));
				
				$Apellidos = DB::table('residentes')->select('Apellidos')
				                                  ->where('Condominio','=',$Condominiox)
				                                  ->where('Residencia','=',$Residenciax)
				                                  ->value(DB::raw("Apellidos"));
				                                  
			    $Email = DB::table('residentes')->select('Email')
				                                  ->where('Condominio','=',$Condominiox)
				                                  ->where('Residencia','=',$Residenciax)
				                                  ->value(DB::raw("Email"));
				                                  
				                                  
				DB::table('calendar')->where('id', $id)->update(['Nombres' => $Nombres ]);                                  
				
				DB::table('calendar')->where('id', $id)->update(['Apellidos' => $Apellidos]);                                 
			
			    DB::table('calendar')->where('id', $id)->update(['email' => $Email]);
			    
					
				//Reservacion duplicada
				
				 $fechaactual = Carbon::now('America/Santo_Domingo');
				 $fechanumactual = strtotime($fechaactual);
				 
				 $Estatus = DB::table('calendar')->select('status')
				                                  ->where('id','=', $id)
				                                  ->value(DB::raw("status")); 
				
				 $Fechadeinicio = DB::table('calendar')->select('fechadeinicio')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("fechadeinicio")); 
				                                      
				 DB::table('calendar')->where('id', $id)->update(['numeroinicio' => strtotime($Fechadeinicio)]);                                     
				 
				 
				 $numeroinicio2 = DB::table('calendar')->select('numeroinicio')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("numeroinicio")); 
				 
				                                      
				 $Fechafinal = DB::table('calendar')->select('fechafinal')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("fechafinal")); 
				                                      
				 DB::table('calendar')->where('id', $id)->update(['numerofinal' => strtotime($Fechafinal)]); 
				 
				 
				 $numerofinal2 = DB::table('calendar')->select('numerofinal')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("numerofinal")); 
				 
				
				 $Localizacion = DB::table('calendar')->select('title')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("title"));
				                                      
				 $Condominio = DB::table('calendar')->select('Condominio')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("Condominio"));                                      
				
				 DB::table('calendar')->where('id', $id)->update(['tipomodulo' => 'Reservacion']);
				
				 $Tipo = DB::table('calendar')->select('tipomodulo')
				                                      ->where('id','=', $id)
				                                      ->value(DB::raw("tipomodulo"));  
				                                      
				                                    
				 $startDate = Carbon::createFromFormat('Y-m-d h:i A', $Fechadeinicio )->startOfDay();
                 $endDate = Carbon::createFromFormat('Y-m-d h:i A', $Fechafinal )->endOfDay(); 
                 
                 
                $numeroinicio = $numeroinicio2 + 150;
                $numerofinal = $numerofinal2 - 150;
               
                
				  $Caso1 = DB::table('calendar')->select()
				                    ->where('numeroinicio','<',$numeroinicio )
				                    ->where('numerofinal','>',$numeroinicio )
				                    //->where($numeroinicio,'>','numeroinicio' )
				                    //->where($numeroinicio,'<','numerofinal' )
				                    //->whereBetween('numeroinicio', [$numeroinicio, $numerofinal])
				                    ->where('title','=',$Localizacion)
				                    ->where('tipomodulo','=',$Tipo)
				                    ->where('status','=','Aprobada')
				                    ->where('Condominio','=',$Condominio)
				                    ->get()
				                    ->count();
				
				    $Caso2 = DB::table('calendar')->select()
				                    ->where('numeroinicio','<',$numerofinal )
				                    ->where('numerofinal','>',$numerofinal )
				                   //->where( $numerofinal,'>','numeroinicio')
				                   //->where( $numerofinal,'<','numerofinal')
				                   //->whereBetween('numerofinal', [$numeroinicio , $numerofinal])
				                   ->where('title','=',$Localizacion) 
				                   ->where('tipomodulo','=',$Tipo)
				                   ->where('status','=','Aprobada')
				                   ->where('Condominio','=',$Condominio)
				                   ->get()
				                   ->count();
				                   
			    	$Caso3 = DB::table('calendar')->select()
				                   ->whereBetween('numeroinicio', [$numeroinicio , $numerofinal])
				                   ->whereBetween('numerofinal', [$numeroinicio , $numerofinal])
				                   ->where('title','=',$Localizacion) 
				                   ->where('tipomodulo','=',$Tipo)
				                   ->where('status','=','Aprobada')
				                   ->where('Condominio','=',$Condominio)
				                   ->get()
				                   ->count();	                   
				                   
				                   
				                   
				                   
				 /*$Actualizarinicio = DB::table('calendar')->select()                                  
				                    ->where(function ($q) use ($numeroinicio,$numerofinal) {
                                                     $q->where('numeroinicio','>=',$numeroinicio )
                                                       ->orWhere('numeroinicio','<=',$numerofinal);}) 
                                    ->where('title','=',$Localizacion)
				                    ->where('tipomodulo','=',$Tipo)
				                    ->where('Condominio','=',$Condominio)
				                    ->get()
				                    ->count();

                 $Actualizarfinal = DB::table('calendar')->select()                                  
				                    ->where(function ($r) use ($numeroinicio,$numerofinal){
                                                     $r->where('numerofinal','>=',$numeroinicio)
                                                       ->orWhere('numerofinal','<=',$numerofinal );}) 
                                    ->where('title','=',$Localizacion)
				                    ->where('tipomodulo','=',$Tipo)
				                    ->where('Condominio','=',$Condominio)
				                    ->get()
				                    ->count();*/                 
				                   
				 if($Estatus == 'En Revision'){
				 DB::table('calendar')->where('id', $id)->update(['status' => 'Reservar']);  
				 }                  
				                                
				 if($Caso1 > 0 || $Caso2 > 0 || $Caso3 > 0){
				 DB::table('calendar')->where('id', $id)->update(['status' => 'Doblereserva']);   
				 }
				 
				 if($numeroinicio2 >= $numerofinal2){
				 DB::table('calendar')->where('id', $id)->update(['status' => 'Fechacruzada']);     
				 }
				 
				 if( $fechanumactual > $numeroinicio2){
				 DB::table('calendar')->where('id', $id)->update(['status' => 'Fechapasada']);      
				 }
				 
				
				
				//Reservacion duplicada
					
					
					/* Insert logs */
					$this->model->logs($request , $id);
					if(!is_null($request->input('apply')))
						return redirect( $this->module .'/'.$id.'/edit?'. $this->returnUrl() )->with('message',__('core.note_success'))->with('status','success');

					return redirect( $this->module .'?'. $this->returnUrl() )->with('message',__('core.note_success'))->with('status','success');
				} 
				else {
					return redirect($this->module.'/'. $request->input(  $this->info['key'] ).'/edit')
							->with('message',__('core.note_error'))->with('status','error')
							->withErrors($validator)->withInput();

				}
				break;
			case 'public':
				return $this->store_public( $request );
				break;

			case 'delete':
				$result = $this->destroy( $request );
				return redirect($this->module.'?'.$this->returnUrl())->with($result);
				break;

			case 'import':
				return $this->PostImport( $request );
				break;

			case 'copy':
				$result = $this->copy( $request );
				return redirect($this->module.'?'.$this->returnUrl())->with($result);
				break;		
		}	
	
	}	

	public function destroy( $request)
	{
		// Make Sure users Logged 
		if(!\Auth::check()) 
			return redirect('user/login')->with('status', 'error')->with('message','You are not login');

		$this->access = $this->model->validAccess($this->info['id'] , session('gid'));
		if($this->access['is_remove'] ==0) 
			return redirect('dashboard')
				->with('message', __('core.note_restric'))->with('status','error');
		// delete multipe rows 
		if(count($request->input('ids')) >=1)
		{
			$this->model->destroy($request->input('ids'));
			
			\SiteHelpers::auditTrail( $request , "ID : ".implode(",",$request->input('ids'))."  , Has Been Removed Successfull");
			// redirect
        	return ['message'=>__('core.note_success_delete'),'status'=>'success'];	
	
		} else {
			return ['message'=>__('No Item Deleted'),'status'=>'error'];				
		}

	}	
	
	public static function display(  )
	{
		$mode  = isset($_GET['view']) ? 'view' : 'default' ;
		$model  = new Reservacionesadmin();
		$info = $model::makeInfo('reservacionesadmin');
		$data = array(
			'pageTitle'	=> 	$info['title'],
			'pageNote'	=>  $info['note']			
		);	
		if($mode == 'view')
		{
			$id = $_GET['view'];
			$row = $model::getRow($id);
			if($row)
			{
				$data['row'] =  $row;
				$data['fields'] 		=  \SiteHelpers::fieldLang($info['config']['grid']);
				$data['id'] = $id;
				return view('reservacionesadmin.public.view',$data);			
			}			
		} 
		else {

			$page = isset($_GET['page']) ? $_GET['page'] : 1;
			$params = array(
				'page'		=> $page ,
				'limit'		=>  (isset($_GET['rows']) ? filter_var($_GET['rows'],FILTER_VALIDATE_INT) : 10 ) ,
				'sort'		=> $info['key'] ,
				'order'		=> 'asc',
				'params'	=> '',
				'global'	=> 1 
			);

			$result = $model::getRows( $params );
			$data['tableGrid'] 	= $info['config']['grid'];
			$data['rowData'] 	= $result['rows'];	

			$page = $page >= 1 && filter_var($page, FILTER_VALIDATE_INT) !== false ? $page : 1;	
			$pagination = new Paginator($result['rows'], $result['total'], $params['limit']);	
			$pagination->setPath('');
			$data['i']			= ($page * $params['limit'])- $params['limit']; 
			$data['pagination'] = $pagination;
			return view('reservacionesadmin.public.index',$data);	
		}

	}
	function store_public( $request)
	{
		
		$rules = $this->validateForm();
		$validator = Validator::make($request->all(), $rules);	
		if ($validator->passes()) {
			$data = $this->validatePost(  $request );		
			 $this->model->insertRow($data , $request->input('id'));
			return  Redirect::back()->with('message',__('core.note_success'))->with('status','success');
		} else {

			return  Redirect::back()->with('message',__('core.note_error'))->with('status','error')
			->withErrors($validator)->withInput();

		}	
	
	}
}
